#!/usr/bin/perl

use vars qw($dumpDir $ptrArgs $workDir);
use strict;

use AgentConfig;

use Status;

use XmlNode;

#
# loadMainConfix() populates the following variables:
#
# $user_homeDir, $installDir, $stdShell, $mailSpool, $maildrop, $mailBoxName,
# $pop_homeDir, $scponly_shell, $majordomo_ldir, $backup_off
#
# $dbType, $dbServer, $dbUser, $dbPw, $dbDB, $dbPort
#
# $mysqlUserServer, $mysqlUserPort, $mysqlUserUser, $mysqlUserPw
#
# $mysql_sock
#



#
# confixx global parameters
#
use vars qw( $user_homeDir $installDir $stdShell $scponly_shell
						 $dbType $dbServer $dbUser $dbDB $dbPw $dbPort
						 $mysqlUserServer $mysqlUserUser $mysqlUserPw $mysqlUserPort
						 $mysql_sock $majordomo_ldir
						 $maildrop $pop_homeDir $mailBoxName $mailSpool $backup_off
                         $storage);

#
# end confixx global parameters
#

#
# parse command line
#
my %arg_opts = ('--help|-h'=>'',
				'--config|-c'=>'s',
				'--get-status|-s'=>'',
				'--dump-accounts|-dc'=>'s',
				'--dump-domains|-dd'=>'s',
				'--dump-all|-da'=>'',
				'--get-content-list|-lc'=>'',
				'--no-content|-nc'=>'',
				'--no-compress|-nz'=>'',
				'--output|-o'=>'s',
				'--status-file|-sf'=>'s',
	       );

my %mapResLimits = ( 'max_subdom' => 'maxsubdomains',
										 'max_dom' => 'maxdomains',
										 'disk_space' => 'maxkb',
										 'max_traffic' => 'maxtransfer',
										 'max_db' => 'maxmysql',
										 'max_box' => 'maxpop',
										 'max_resp' => 'maxautoresponder',
										 'max_maillists' => 'maxmaillist',
									 );

my %mapResPermis = ('create_domains' => 'maxdomains',
										'manage_phosting' => 'maxkunden',
										'manage_subdomains' => 'maxsubdomains',
										'change_limits' => 'maxkunden',
										'manage_dns' => 'dns',
										'manage_log' => 'maxkunde',
										'manage_sh_access' => 'scponly',
										'manage_not_chroot_shell' => 'shell',
										'make_dumps' => 'maxkunden',
										'manage_maillists' => 'maxmaillist',
										'manage_crontab' => 'maxcronjobs',
									 );

my %mapResPinfo = ( 'company' => 'firma',
										'phone' => 'telefon',
										'fax' => 'fax',
										'address' => 'anschrift',
										'city' => 'plzort',
										'state' => '',
										'zip' => 'plz',
										'country' => 'land',
										'locale' => 'language',
										'email' => 'emailadresse' );

my %mapUserPinfo = ( 'company' => 'firma',
										 'phone' => 'telefon',
										 'fax' => 'fax',
										 'address' => 'anschrift',
										 'city' => 'plzort',
										 'state' => '',
										 'zip' => 'plz',
										 'country' => 'land',
										 'locale' => 'language',
										 'email' => 'emailadresse' );


my %mapCustLimits = ( 'max_subdom' => 'maxsubdomains',
											'disk_space' => 'maxkb',
											'max_traffic' => 'maxtransfer',
											'max_db' => 'maxmysql',
											'max_box' => 'maxpop',
											'max_resp' => 'maxautoresponder',
											'max_maillists' => 'maxmaillist',
										);


my %comulatLimits = ( 'max_db' => 1 );

my %mapCustPermis = ('manage_subdomains' => 'maxsubdomains',
										 'manage_log' => 1,
										 'manage_maillists' => 'maxmaillist',
										 'manage_ftp_password' => 1,
										 'manage_crontab' => 'maxcronjobs',
										);

my %mapCustScripting = ('ssi'=>'ssi',
												'php'=>'php',
												'cgi'=>'perl',
												'perl'=>0);

my %mapLocales = ('de' => 'de-DE',
									'en' => 'en-US',
									'es' => 'es-ES',
									'fr' => 'fr-FR',
									'gr' => 'el-GR',
									'it' => 'it-IT',
									'ru' => 'ru-RU');

my %mapCountries = ('deutschland' => 'DE');

my %mapTemplate = ( 'php' => [ 'php', 'L' ],   ##  xmlNameAttribute => [ fieldName, typeOfItem ]
										'perl' => [ 'perl', 'L' ],
										'python' => [ 'modpython', 'L' ],
										'ssi' => [ 'ssi', 'L' ],
										'errdocs' => [  'fehlerseiten', 'L' ],
										'webmail' => [  'webmail', 'L' ],
										'asp' => [ 'asp', 'L' ],
										'fp' => [ 'frontpage', 'L' ],
										'coldfusion' => [ 'coldfusion', 'L' ],
										'webstat' => [ 'statistik', 'L' ],
										'maillists' => [ 'maxmaillist', 'L' ],
										'max_box' => [ 'maxpop', 'N' ],
										'max_db' => [ 'maxmysql', 'N' ] ,
										'max_wu' => [ 'maxftp', 'N' ],
										'max_subdom' => [ 'maxsubdomains', 'N' ],
										'max_maillists' => [ 'maxmaillist', 'N' ],
										'disk_space' => [ 'maxkb', 'B' ],
										'max_traffic' => [ 'maxtransfer', 'B' ],
										'max_resp' => ['maxautoresponder', 'N']
									);


#
# global variables
#
my (%preparedCustomers, %exclIp, %idn2Utf8cache);
#
# end global variables
#

require "agent.include.pl";

$ptrArgs = &getArguments (\@ARGV,\%arg_opts);

my ($outPath,$dumpDir,$dumpFile,$statusFile,$workDir);

$workDir = AgentConfig::cwd();

$dumpFile = $workDir.'/dump.xml';
$statusFile = $workDir.'/dumping-status.xml';
$dumpDir = $workDir.'/pma';

my $objDumpStatus = &makeDumpStatus($ptrArgs->{'status-file'}||$statusFile);


#
# find & load main config
#

my $rootName = 'migration-dump';

unless ( loadMainConfig( $ptrArgs->{'config'} ) ) {

  if ( exists $ptrArgs->{'get-status'} ) {
    printAgentStatus();
    exit 0;
  }else{
    if ( exists( $ptrArgs->{'dump-all'} ) ||
         exists( $ptrArgs->{'dump-accounts'} ) ||
         exists( $ptrArgs->{'dump-domains'} ) ) {

	  die "Error: confixx config file 'confixx_main.conf' is not found\n";
	}
  }
}

my ($majorVersion, $minorVersion, $patchLevel) = getConfixxVersion();

#
# get db connect
#

my $wrapDbh = getDbConnect($dbType, $dbUser, $dbPw, $dbDB, $dbServer);
unless ($wrapDbh) {
  die "Error: can not connect to confixx database\n";
}

my $wrapUserMysql;
if ($mysqlUserUser) {
  my $socket = $mysqlUserPort if -S $mysqlUserPort;
  my $port = $mysqlUserPort if $mysqlUserPort =~ /^\d+$/;

  $wrapUserMysql = getDbConnect('mysql', $mysqlUserUser, $mysqlUserPw,
								'mysql', $mysqlUserServer, undef, $socket, undef, undef, $port);
}

#
# get MIME Base64 encoder
#
my $wrapBase64 = makeMIMEBase64();

my $ID=0;

if(exists $ptrArgs->{'get-status'}){
  printAgentStatus();
  exit 0;
}elsif(exists ($ptrArgs->{'dump-all'}) ||
       exists ($ptrArgs->{'dump-accounts'}) ||
       exists ($ptrArgs->{'dump-domains'})){

  my ($root,@accounts,@domains,$ptrAccounts,$ptrDomains, $value);

  initStorage();

  getDumpDir($dumpDir);

  if (exists $ptrArgs->{'no-compress'}) {
	setCompress(0);
  }

  &printToLog("Work dir: $workDir");
  &printToLog("Dump file: $dumpFile");
  &printToLog("Status file: ".$objDumpStatus->{'FILE'}->());


  if ($value = $ptrArgs->{'dump-accounts'}){
  	if ($value eq "-") {
		$value = <STDIN>;
		chomp $value;
	}
    @accounts = split(/\s*,\s*/,$value);
    $ptrAccounts = \@accounts;
  }

  if ($value = $ptrArgs->{'dump-domains'}){
  	if ($value eq "-") {
		$value = <STDIN>;
		chomp $value;
	}
    @domains = split(/\s*,\s*/,$value);
    $ptrDomains = \@domains;

	# translate domains into ASCII representation
	foreach my $domain (@domains) {
		next if ($domain =~ /^[\x00-\x7f]*$/);
		my $idn = &utf8ToIdn($domain);
		$idn2Utf8cache{$idn} = $domain;
		$domain = $idn;
	}
  }
#
# generate a xml dump
#

  $root = &getConfixx2PleskDump($dumpDir, $ptrAccounts, $ptrDomains);

#
# print dump to output
#

  $storage->finish($root);

}elsif(exists $ptrArgs->{'get-content-list'}){
  makeContentList();
}else{
  &printHelp();
}

exit 0;

#
# end main
#
#==============================================================

#==============================================================
#
# confixx subroutines
#

my (%admin); ## hash with admin settings

sub getConfixx2PleskDump{
  my($dumpDir,$ptrAccounts,$ptrDomains) = @_;
  my ($root,$item,$reseller,%resellers,%customers,$sql,$ptrRow,
     $ptrResellers,$full);

  $root = XmlNode->new('migration-dump', 'attributes'=>{'agent-name'=>'ConfixxX'});

  unless(ref($wrapDbh)=~/HASH/ && ref($wrapDbh->{'EXECUTE'})=~/CODE/){
    $root->{'CONTENT'}->("Error: there is no connect to database");
    &printToError("Error: unable to connect to SQL database");
    return $root;
  }

#
# get admin settings
#
	$sql = "SELECT * FROM admin";
	if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
		my ( $ptrHash );
		if ( $ptrHash = $wrapDbh->{'FETCHHASH'}->() ) {
			%admin = %{$ptrHash};
		}
	}
	$wrapDbh->{'FINISH'}->();
#
# end get admin settings
#

  printToLog('Reading IP information ...',1);
  readIpInfo();
  printToLog(' OK');

#
# prepare reseller
#
  if(
     (ref($ptrAccounts)=~/ARRAY/ && (@{$ptrAccounts}>0)) ||
     (ref($ptrDomains)=~/ARRAY/ && (@{$ptrDomains}>0))
    ){
    my (@res,@cust,$acc,$list);
    if (ref($ptrAccounts)=~/ARRAY/){
      foreach $acc (@{$ptrAccounts}){
		if ($acc=~/^res\d+$/){
		  $resellers{$acc}=1;
		}else{
		  $customers{$acc}=1;
		}
      }
    }
    $list = join(',',keys %customers);
    if($list){
      $sql = "select distinct anbieter from kunden where (kunde in ($list))";
      if($wrapDbh->{'EXECUTE'}->($sql)){
				while( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$acc = $ptrRow->[0];
					unless(exists $resellers{$acc}){
						$resellers{$acc} = 0;
					}
				}
			}
      $wrapDbh->{'FINISH'}->();
    }

    if (ref($ptrDomains)=~/ARRAY/){
      $list = join(',',map {"'$_'"} @{$ptrDomains});
      if($list){
				$sql = "select distinct anbieter,kunde from domains where (domain in ($list))";
				if($wrapDbh->{'EXECUTE'}->($sql)){
					while( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
						$acc = $ptrRow->[0];
						unless(exists $resellers{$acc}){
							$resellers{$acc} = 0;
						}
						$acc = $ptrRow->[1];
						unless(exists $customers{$acc}){
							$customers{$acc} = 0;
						}
					}
				}
				$wrapDbh->{'FINISH'}->();
      }
    }
  }else{
    if($wrapDbh->{'EXECUTE'}->("select anbieter from anbieter")){
      while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$resellers{$ptrRow->[0]}=1;
      }
    }
    $wrapDbh->{'FINISH'}->();
  }
  $ptrResellers = \%resellers;

  my $domainsCount = 0;
  if ($ptrDomains) {
		$domainsCount = scalar(@{$ptrDomains});
  }

  $objDumpStatus->{'COUNTS'}->(scalar (keys %resellers), $domainsCount);

  my %leftResellers = %resellers;
  my ($list);

  while (($reseller,$full)=each(%resellers)){
    &printToLog("Client '$reseller' is started");
	#
	# work with status of dump
	#
    $objDumpStatus->{'ACCOUNT'}->($reseller);
    $objDumpStatus->{'PRINT'}->();
    $list = join(',',map {"'$_'"} keys %leftResellers);
    if($list){
      $sql = "SELECT count(domain) FROM domains WHERE (richtigedomain in (0,1)) ".
				" AND (anbieter in ($list))";
      if($wrapDbh->{'EXECUTE'}->($sql)){
				if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$domainsCount = $ptrRow->[0];
				}
      }
      $wrapDbh->{'FINISH'}->();
    }else{
      $domainsCount=0;
    }

    $objDumpStatus->{'PRINT'}->();

	#
	# end work with status of dump
	#

    $item = &makeResellerNode($reseller,$full,\%customers,$ptrDomains);
    if(ref($item)=~/XmlNode/ && ref($item->{'PRINT'})=~/CODE/){
      $root->{'ADDCHILD'}->($item);
      &printToLog("Client '$reseller' is successfully dumped");
    }else{
      &printToLog("Client '$reseller' is not dumped");
    }

    delete $leftResellers{$reseller};
  }

  $objDumpStatus->{'COUNTS'}->(0,0);
  $objDumpStatus->{'PRINT'}->();

#
# end prepare reseller
#

  return $root;
}


#
# sub makeResellerNode
#            - create a 'client'-node
# Arguments:
#            $nameRes   - name of reseller
#            $full      - 1 dump all domains of the reseller
#            $$ptrCustomersHash
#                       - reference to hash of customer-info to dump
#            $ptrDomainsArr
#                       - reference to array of domains to dump

sub makeResellerNode {
  my $nameRes = shift;
  my $full = shift;
  $full = 1 unless defined($full);
  my $ptrCustomersHash = shift || {};
  my $ptrDomainsArr = shift || [];

  my ($item,$root,$sql,$ptrHash,$value);

	my $nocontent = (exists $ptrArgs->{'no-content'})?1:0;

  $sql = "select * from anbieter where anbieter ='$nameRes'";

  unless( $wrapDbh->{'EXECUTE'}->( $sql ) ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }
  unless( $ptrHash = $wrapDbh->{'FETCHHASH'}->() ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }

  $root = XmlNode->new('client', 'attributes' => {'name' => $nameRes});

	unless ( $nocontent ) {

#  $value = $ptrHash->{'firma'};
#  $root->{'ATTRIBUTE'}->('contact',$value) if $value;
		$root->setAttribute('contact',$nameRes);

	}	## no content

	$item = &makePasswordNode( $ptrHash->{'longpw'} );
	$root->addChild($item);

	$item = XmlNode->new('status');
	my $node;

	if($ptrHash->{'gesperrt'}) {
 	   $node = XmlNode->new('disabled-by', 'attributes' => {'name' => 'admin'});
	} else {
	   $node = XmlNode->new('enabled');
	}

	$item->{'ADDCHILD'}->($node);
	$root->addChild($item);

	unless ( $nocontent ) {

		&addPinfo($root,$ptrHash,\%mapResPinfo);

		&addLimits($root,$ptrHash,\%mapResLimits);

		&addPermissions($root,$ptrHash,\%mapResPermis);
	}

  $wrapDbh->{'FINISH'}->();

	# IP-pool
	my @ips = getIpPool($nameRes);
	if (@ips) {
		my $ip_pool = XmlNode->new('ip_pool');
		$root->addChild($ip_pool);

		foreach my $ip (@ips) {
			$ip_pool->addChild(makeIpNode($ip));
		}
	}

#
# templates
#
	{
		my (%templates, $name, $ident, $ptrRow );
		$sql = "SELECT ident,name FROM angebote WHERE anbieter='$nameRes'";
		$wrapDbh->{'EXECUTE'}->($sql);
		while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
			($ident,$name) = @{$ptrRow};
			while ( exists( $templates{$name} ) ) { ## get an unique name of template
				$name .= '_'.$ident;
			}
			$templates{$name} = $ident;
		}
    $wrapDbh->{'FINISH'}->();

		&addTemplates( $root, \%templates, $ptrHash );
	}
#
# end templates
#
  my (@domains,$domain,@subdomains,$subdomain,@addSubDomain,%allSubDomains,
		 $ptrDomains,$ptrSubdomains,$ptrRow, %do2ku);

  if( $full ){
    $sql = "SELECT domain, kunde FROM domains WHERE (richtigedomain=1) AND (anbieter='$nameRes')";
    $wrapDbh->{'EXECUTE'}->($sql);
    while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
      push @domains, $ptrRow->[0];
			$do2ku{$ptrRow->[0]} = $ptrRow->[1];
    }
    $wrapDbh->{'FINISH'}->();

  }else{
    while( my( $cust, $full ) = each( %{$ptrCustomersHash} ) ){
      next unless $full;
      $sql = "SELECT domain, kunde FROM domains WHERE (richtigedomain=1) AND (anbieter='$nameRes') AND (kunde='$cust')";
      $wrapDbh->{'EXECUTE'}->($sql);
      while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				push @domains,$ptrRow->[0];
				$do2ku{$ptrRow->[0]} = $ptrRow->[1];
      }
	  $wrapDbh->{'FINISH'}->();
    }
    my $list = join(',',map {"'$_'"} @{$ptrDomainsArr});
    if($list){
      $sql = "SELECT domain, kunde FROM domains WHERE richtigedomain IN (0,1) ".
				"AND (anbieter='$nameRes') AND (domain IN ($list))";
      $wrapDbh->{'EXECUTE'}->($sql);
      while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				push @domains,$ptrRow->[0];
				$do2ku{$ptrRow->[0]} = $ptrRow->[1];
      }
      $wrapDbh->{'FINISH'}->();
    }
  }

#
# loop by domains
#

	my ($initFactor,%limitFactor,$cnt,$newFactor,$countExtraDomains,$kunde);

	%limitFactor = map {$_ => 1} @domains;

  while( @domains ){

		$domain = shift @domains;
		$kunde = $do2ku{$domain};

    &printToLog("Domain '$domain' is started");

    $objDumpStatus->{'DOMAIN'}->($domain);
    $objDumpStatus->{'PRINT'}->();

		%allSubDomains = ($domain => 1); ## init hash

    ($ptrDomains,$ptrSubdomains) = addDomainNode($root,$domain,\@ips,$ptrHash);

		map { $allSubDomains{$_} = 1 } @{$ptrSubdomains}; ## add prepared subdomains

		if ( $cnt = @subdomains = @{$ptrDomains} ) {

#
# calculate adjustment factor
#
			$limitFactor{$domain} ||= 1;
			$newFactor = $limitFactor{$domain}*($cnt+1); ## subdomains + $domain
			$limitFactor{$domain} = $newFactor;
			map { $limitFactor{$_} = $newFactor } @subdomains;

#
# translate subdomain to domains
#
			while ( @subdomains ) {
				$subdomain = shift(@subdomains);
				&printToLog ( "transfer subdomain '$subdomain' to domain is started" );

				$objDumpStatus->{'DOMAIN'}->($subdomain);
				$objDumpStatus->{'PRINT'}->();

				$allSubDomains{$subdomain} = 1; ## add transfered to domain subdomain
				$do2ku{$subdomain} = $kunde;

				($ptrDomains,$ptrSubdomains) = &addDomainNode($root,$subdomain,\@ips,$ptrHash);
				$countExtraDomains++;

				map { $allSubDomains{$_} = 1 } @{$ptrSubdomains}; ## add prepared subdomains
				push @subdomains,@{$ptrDomains};

#
# calculate adjustment factor
#
				if ( $cnt = @{$ptrDomains} ) {
					$limitFactor{$subdomain} ||= 1;
					$newFactor = $limitFactor{$subdomain}*($cnt+1); ## subdomains + $domain
					$limitFactor{$subdomain} = $newFactor;
					map { $limitFactor{$_} = $newFactor } @{$ptrDomains};
				}

				&printToLog ( "sbdomain '$subdomain' is transfered" );
			}
		}

#
# add to domain subdomains with yet not processed
#
		my $list = join(',',map {"'$_'"} keys %allSubDomains);
		if ( $list ) {
			my (%subdom,$cnt,@pnts);
			$sql = "SELECT domain FROM domains WHERE richtigedomain = 0 AND ".
				" ( domain like '\%.$domain' ) AND NOT ( domain IN ($list) )";
      $wrapDbh->{'EXECUTE'}->($sql);
      while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$cnt = @pnts = ($ptrRow->[0] =~ /\./g);  ## get level of subdomain (count of dot)
				if ( $ptrRow->[0] =~ /\*/ ) { ## skip wildcard-subdomains
					$allSubDomains{$ptrRow->[0]} = 1;
				} else {
					push @{$subdom{$cnt}},$ptrRow->[0];
				}
      }
      $wrapDbh->{'FINISH'}->();
			if ( %subdom ) {
#
# claculate minimum of subdomain's levels
#
				my $minCnt = (sort { $a <=> $b } keys %subdom)[0];

#
# transfer subdomain to domain
#

				map {
					push( @domains, $_ );
					$do2ku{$_} = $kunde;
					$countExtraDomains++;
				} @{$subdom{$minCnt}};

#
# recalc limit factor
#
				my ($newFactor,$delta,$reDomain,$oldFactor);

				$limitFactor{$domain} ||= 1;
				$oldFactor = $limitFactor{$domain};
				$newFactor = @{$subdom{$minCnt}}+$oldFactor;

## correct old factor for currect domain
				$delta = $newFactor/$oldFactor;
				$reDomain = qr/\Q$domain\E$/;
				map { $limitFactor{$_} *= $delta if /$reDomain/ } keys %limitFactor;

## add new factor
				map { $limitFactor{$_} = $newFactor } @{$subdom{$minCnt}};

			}
		}

    &printToLog("Domain '$domain' is dumped");

  }

	my $ptrKundeLimits =  &getKundeLimits ( $root, \%do2ku );

	&correctLimits( $root, \%limitFactor );

	&correctClientsLimits ( $root, $countExtraDomains, $ptrKundeLimits, \%do2ku );


#
# end loop by domains
#
  return $root;
}

#
# add teplate items into the client node
#
sub addTemplates {
	my ($root, $ptrNames, $ptrResellerHahs ) = @_;

	unless( ref($root) =~ /XmlNode/ && ref($ptrNames) =~ /HASH/ ){
		&printToError("Error: sub addTemplates: wrong parameters");
		return;
	}

	my %TemplateIDs = reverse %{$ptrNames};
	my( $sql, $templName, $ptrTemplate, $templID, $itemTempl, $item );
	my $cntTemplates = 0;
	foreach $templID ( sort{ $a <=> $b } keys %TemplateIDs){
		$templName = $TemplateIDs{$templID};
		$sql = "SELECT * FROM angebote WHERE ident=$templID";
		unless( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			&printToError( "Error: sub addTemplates: can't find template with # ".$templID );
			next;
		}
		$ptrTemplate = $wrapDbh->{'FETCHHASH'}->();

		$itemTempl = XmlNode->new( 'domain-template', 'attributes' => {'name' => $templName} );

		my($xmlItemName, $ptrArr, $fieldName, $type, $value );

		while( ( $xmlItemName, $ptrArr ) = each %mapTemplate ){
			if( ref( $ptrArr ) =~ /ARRAY/ ) {
				( $fieldName, $type ) = @{$ptrArr};
			} else {
				$fieldName = $ptrArr;
				$type = '';
			}
			unless( exists( $ptrTemplate->{$fieldName} ) ){
				next;
			}

			$value = $ptrTemplate->{$fieldName};

			if( $type =~ /L/i ){ ## logical
				$value = $value? 'true': 'false';

			} elsif ( $type =~ /B/i ){ ## bytes
				if ($value != -1) {
					$value *= 1024;
				}
			}

			$item = XmlNode->new( 'template-item', 'content' => $value, 'attributes' => {'name' => $xmlItemName} );

			$itemTempl->addChild( $item );
		}

#
# other items
#
		if( $ptrTemplate->{'shell'} ) {
			my ($shell);

			if ( $ptrTemplate->{'shell'} == 1 ){
				$shell = $stdShell || '/bin/sh';

			} elsif( $ptrTemplate->{'shell'} == 2 ){
				$shell = $scponly_shell;
			}

			if( $shell ) {
				$itemTempl->addChild(XmlNode->new( 'template-item', 'content' => $shell, 'attributes' => {'name' => 'shell'} ));
			}
		}

		# If 'perl' was specified - add CGI also
		if ($ptrTemplate->{'perl'}) {
			$itemTempl->addChild(XmlNode->new('template-item', 'content' => 'true', 'attributes' => {'name' => 'cgi'}));
		}

		# All templates are with Plesk's physical hosting
		$itemTempl->addChild(XmlNode->new('template-item', 'content' => 'physical', 'attributes' => {'name' => 'vh_type'}));

		$wrapDbh->{'FINISH'}->();

		$root->{'ADDCHILD'}->( $itemTempl ); ## append to root item
		$cntTemplates++;
	}
	return $cntTemplates;
}

sub correctLimits {
	my ($root, $ptrFactor, $cntExtraDomains ) = @_;
	unless( ref($root)=~/XmlNode/ && ref($ptrFactor)=~/HASH/ ){
		&printToError("Error: sub correctLimits: wrong parameters");
		return;
	}

	my($ptrKinds,$item,$domain,$domainItem,$factor,$ptrLimits,
		 $value,$ret,$limitItem,$name,%limits, $itemName, $limitMaxDomains);
	$ret = 0;

#
# clean summators
#
	foreach $name (keys %comulatLimits) {
		$limits{$name} = undef;
	}
#
# end clean summators
#

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};
		if ( $itemName eq 'domain' ) {

			$domain = $domainItem->{attributes}->{name};

			$factor = $ptrFactor->{$domain};
			next unless $factor > 1; ## There is a factor which more than 1

			&printToLog ("update limits of '$domain' with factor $factor");

            $ptrLimits = getKindsRef($domainItem);
			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value>0 ) { ## a positive value

					if ( exists( $limits{$name} ) ) { ## comulative limit
						if ( $limits{$name} ) {
							$limits{$name} += $value;
						} else {
							$limits{$name} = $value;
						}

					} else {
						$value /= $factor;
						$limitItem->{'CONTENT'}->( int($value) );
						$ret++;
					}
				}
			}
		} elsif ( $itemName eq 'limit' ) {
			$name = $domainItem->{attributes}->{name};
			if ( $name eq 'max_dom' ) {
				$limitMaxDomains = $domainItem; ## store reference
			}
		}
	}

#
# correct maximum of domains
#
	if ( $limitMaxDomains && $cntExtraDomains ) {
		$value = $limitMaxDomains->{'CONTENT'}->();
		if ( $value > 0 ) {
			$value += $cntExtraDomains;
			$limitMaxDomains->{'CONTENT'}->($value);
		}
	}
#
# /correct maximum of domains
#


#
# correct comulative limits
#
	foreach $limitItem ( @{$ptrKinds} ) { ## loop by limits
		next unless $limitItem->{name} eq 'limit';

		$name = $limitItem->{attributes}->{name};
		next unless exists $limits{$name}; ## check if name is suit

		$value = $limitItem->{'CONTENT'}->();
		if ( ( $value > 0 ) && ( $value < $limits{$name} ) ) {
			$limitItem->{'CONTENT'}->( $limits{$name} ); ## increase limit
		}
	}
#
# end correct comulative limits
#

	return $ret;
}
#
#
#

sub getKundeLimits {
	my ( $root, $ptrDo2Ku ) = @_;
	unless( ref($root) =~ /XmlNode/ &&
					ref($ptrDo2Ku) =~ /HASH/
				){
		&printToError("Error: sub getKundeLimits: wrong parameters");
		return undef;
	}

	my ( $ptrKinds, $domainItem, $itemName, $domain, $kunde, $name, $value,
			 $ptrLimits, $limitItem);

	my $ret = {};

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};

		if ( $itemName eq 'domain' ) {
			$domain = $domainItem->{attributes}->{name};
			$kunde = $ptrDo2Ku->{$domain};
			next unless $kunde;
			next if exists $ret->{$kunde};

			$ret->{$kunde} = {};

                        $ptrLimits = getKindsRef($domainItem);

			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value > 0 ) {
					$ret->{$kunde}->{$name} = $value;
				}
			}
		}
	}
	return $ret;
}

my ( %Domain2IDN );

sub correctClientsLimits {
	my ($root, $cntExtraDomains, $ptrKu2Lim,  $ptrDo2Ku ) = @_;

	unless( ref($root) =~ /XmlNode/ &&
					ref($ptrDo2Ku) =~ /HASH/ &&
					ref($ptrKu2Lim) =~ /HASH/
				){
		&printToError("Error: sub correctClientLimits: wrong parameters");
		return;
	}

	my ($ptrKinds, $domainItem, $itemName, $domain, $ptrLimits, %domLimits, $limitItem, %limit2dom,
			$name, $value, $limitMaxDomains, %cliLimits, $ptrArr, $kunde, $limName, %ku2do);


	while (($domain,$kunde) = each (%{$ptrDo2Ku})){

#
# push IDN-translated domains name
#
		push @{$ku2do{$kunde}}, ( $Domain2IDN{$domain} || $domain );
	}

	foreach $kunde (keys %ku2do){
		unless ( @{$ku2do{$kunde}} > 1 ) {
			delete $ku2do{$kunde};
		}
	}

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};

		if ( $itemName eq 'domain' ) {
			$domain = $domainItem->{attributes}->{name};

                        $ptrLimits = getKindsRef($domainItem);

			$domLimits{$domain} = [ {}, $domainItem ];

			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value > 0 ) { ## a positive value
					$domLimits{$domain}->[0]->{$name} = [ $value, $limitItem ];
					unless ( exists( $limit2dom{$name} ) ) {
						$limit2dom{$name}={};
					}
					$limit2dom{$name}->{$domain} = $value;
				}
			}

		} elsif ( $itemName eq 'limit' ) {
			$name = $domainItem->{attributes}->{name};
			if ( $name eq 'max_dom' ) {
				$limitMaxDomains = $domainItem; ## store reference
			}
			$value = $domainItem->{'CONTENT'}->();
			if ( $value > 0 ) { ## a positive value
				$cliLimits{$name} = [ $value, $domainItem ];
			}
		}
	}

#
# correct maximum of domains
#
	if ( $limitMaxDomains && $cntExtraDomains ) {
		$value = $limitMaxDomains->{'CONTENT'}->();
		if ( $value > 0 ) {
			$value += $cntExtraDomains;
			$limitMaxDomains->{'CONTENT'}->($value);
			$cliLimits{'max_dom'}->[0] = $value;
		}
	}
#
# /correct maximum of domains
#

	unless ( keys %ku2do ) {
		return 0;
	}

#
# check overdraft
#
	foreach $name ( keys %cliLimits )  {
		$value = 0;
		map { $value += $_ } grep { $_ > 0 } values %{$limit2dom{$name}};

		if ( $cliLimits{$name}->[0] <= 0 || $value <= $cliLimits{$name}->[0] ) {

			delete $cliLimits{$name};
			delete $limit2dom{$name};

			foreach $domain ( keys %domLimits ) {
				foreach $limName ( keys ( %{$domLimits{$domain}->[0]} ) ) {
					if ( $limName eq $name ) {
						delete $domLimits{$domain}->[0]->{$name};
					}
				}
			}

		}
	}

#
# main loop by limits
#
	my ( %limit, %fact, $limVal, $factVal, $factSum, @dom2work, $kf, $oldLimit, $newLimit,
		 $dom, $val, $newValue );

	foreach $name ( keys %cliLimits )  {

		print "correct '$name' limit ...";

#
# loop by kunde
#
		while ( ($kunde, $ptrArr) = each( %ku2do ) ) {
			%limit = ();
			%fact = ();
			@dom2work = ();
			$factSum = 0;
			$oldLimit = 0;
#
# get limits & facts
#
			foreach $dom (@{$ptrArr}) { ## get limits & facts

				unless(exists $domLimits{$dom}){
					&printToError("Error: sub correctClientsLimits: domain '$dom' is't found in the dump");
					next;
				}

				# 70476
				unless (exists($domLimits{$dom}->[0]->{$name})) {
					next;
				}

				$limVal = $domLimits{$dom}->[0]->{$name}->[0];
				next unless $limVal > 0;
				push @dom2work, $dom;
				$limit{$dom} = $limVal;
				$oldLimit += $limVal;

				$factVal = &getFactUsage( $name, $dom, $domLimits{$dom}->[1]);

				$fact{$dom} = defined( $factVal )? $factVal: $limVal;
				if ( $fact{$dom} > 0 && $factSum >= 0 ) {
					$factSum += $fact{$dom};
				} elsif ( $fact{$dom}< 0 ) {
					$factSum = -1;
				}
			}

#
# correct limits
#
			if ( $factSum <= 0 ) {
				if ( $oldLimit > 0 ) {
					$kf = $ptrKu2Lim->{$kunde}->{$name} / $oldLimit;
					$newLimit = 0;
					foreach $dom ( @dom2work ) {
						$val  = int( $limit{$dom} * $kf );
						$limit{$dom} = $val;
						$newLimit += $val;
					}
				}
			} else {
				if ( $factSum <= $ptrKu2Lim->{$kunde}->{$name} &&
						 $ptrKu2Lim->{$kunde}->{$name} > 0
					 ) {
					$kf = $ptrKu2Lim->{$kunde}->{$name} / $factSum;
				} else {
					$kf = 1;
				}
				$newLimit = 0;
				foreach $dom ( @dom2work ) {
					$val  = int( $fact{$dom} * $kf );
					$limit{$dom} = $val;
					$newLimit += $val;
				}
			}
#
# save new domain's limit
#
			while ( ($dom,$val) = each(%limit) ) {
				$domLimits{$dom}->[0]->{$name}->[0] = $val;
			}
#
# save new client's limit
#
			if ( $newLimit > $oldLimit ) {
				$cliLimits{$name}->[0] += ($newLimit - $oldLimit);
			}
		}

		print "\t  done\n";

	}
#
# save to xml
#
	my $ret = 0;
	foreach $name (keys (%cliLimits)) {
		$domainItem = $cliLimits{$name}->[1];
		$value = $domainItem->{'CONTENT'}->();
		if ( $value < $cliLimits{$name}->[0] ) {
			$domainItem->{'CONTENT'}->( $cliLimits{$name}->[0] );
			$ret++;
		}
	}

	foreach $dom ( keys (%domLimits) ) {
		foreach $name ( keys %{$domLimits{$dom}->[0]} ) {
			$limitItem = $domLimits{$dom}->[0]->{$name}->[1];
			$value = $limitItem->{'CONTENT'}->();
			$newValue = $domLimits{$dom}->[0]->{$name}->[0];
			unless ( $value == $newValue ) {
				$limitItem->{'CONTENT'}->( $newValue );
				$ret++;
			}
		}
	}

	return $ret;

}

sub getFactUsage {
	my ( $limit, $domain, $xmlDomainItem) = @_;
	my ( $retValue, $item, $ret );

	if ( $limit eq 'max_subdomain'){
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'phosting');
		if ( $item ) {
                        $ret = getKindsRef($item, 'subdomain' );
			if ( $ret ) {
				$retValue = @{$ret};
			}
		}

	} elsif ( $limit eq 'max_dom' ) {
# nothing to do

	} elsif ( $limit eq 'disk_space' ) {
		$retValue = 0;
        $item = getKind($xmlDomainItem, 'phosting');
		if ( $item ) {
			my ($path, $cmd);
			my $tar = AgentConfig::tarBin();
			my $cat = AgentConfig::catBin();
			$ret = $item->{attributes};
			while ( my( $key, $value) = each( %{$ret} ) ){
				next unless ($key =~ /^cid(_|$)/);
				$path = "$dumpDir/$value";
				next unless ( -f "$path.aa" );
				$cmd = "cat $path.* | $tar -z -t -vv -f - ";
				if ( open( IN, "$cmd |") ) {
					while ( <IN> ) {
#
#-rw-r--r-- apach e/wws      256 2005-02-15 09:28:21 ./_vti_cnf/.htaccess
#                      --> size <---
#
						$retValue += ( split( ' ', $_, 4 ) )[2];
					}
					close( IN );
				}
			}
			$retValue /= 1024;
		}

  } elsif ( $limit eq 'max_traffic' ) {
		$retValue = -1;

	} elsif ( $limit eq 'max_wu' ) {

	} elsif ( $limit eq 'max_db' ) {
		$retValue = 0;
                $ret = getKindsRef($xmlDomainItem, 'database');
		if ( $ret ) {
			$retValue = @{$ret};
		}

	} elsif ( $limit eq 'max_box' ) {
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'mailsystem');
		if ( $item ) {
                        $ret = getKindsRef($item, 'mailuser');
			if ( $ret ) {
				foreach $item (@{$ret}) {
					if ( getKind($item, 'mailbox') ) {
						$retValue++;
					}
				}
			}
		}

	} elsif ( $limit eq 'mbox_quota' ) {
		$retValue = -1;

	} elsif ( $limit eq 'max_redir' ) {
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'mailsystem');
		if ( $item ) {
                        $ret = getKindsRef($item, 'mailuser');
			if ( $ret ) {
				foreach $item (@{$ret}) {
					if ( getKind($item, 'redirect') ) {
						$retValue++;
					}
				}
			}
		}

	} elsif ( $limit eq 'max_mg' ) {

	} elsif ( $limit eq 'max_resp' ) {

	} elsif ( $limit eq 'max_maillists' ) {
                $ret = getKindsRef($xmlDomainItem, 'maillist');
		$retValue = $ret? @{$ret}: 0;
		return $retValue;

	} elsif ( $limit eq 'max_webapps' ) {

	} elsif ( $limit eq 'ans_freq' ) {

	} elsif ( $limit eq 'ans_count' ) {

	}

	return $retValue;
}


sub getIpPool( $ )
{
	my ($nameRes) = @_;

	my (@ips,$nodePool,$ptrRow,$ip,$sql);

	$sql = "SELECT standardip FROM anbieter WHERE anbieter='$nameRes'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		($ip) = @{$wrapDbh->{'FETCHROW'}->()};
		$ip =~ s/^\s+//;
		$ip =~ s/\s+$//;
	}
	$wrapDbh->{'FINISH'}->();

	# Check IP
	if ($ip) {
		unless ($ip eq $admin{'standardip'}) {
			$sql = "SELECT ip FROM ipadressen WHERE ip='$ip'";
			unless ($wrapDbh->{'EXECUTE'}->($sql)) {
				$ip = $admin{'standardip'};
			}
			$wrapDbh->{'FINISH'}->();
		}
	} else {
		# Get standard IP from admin
		$ip = $admin{'standardip'};
	}

	push @ips, $ip;

	$sql = "SELECT ip FROM ipadressen WHERE anbieter='$nameRes'";
	if ($wrapDbh->{'EXECUTE'}->( $sql )) {
		while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
			$ip = $ptrRow->[0];
			$ip =~ s/^\s+//;
			$ip =~ s/\s+$//;

			push @ips, $ip;
		}
	}
	$wrapDbh->{'FINISH'}->();

	return uniq(@ips);
}

#
# addDomainNode
#            - create and add a domain node into the xml tree
# Arguments:
#
#    $root      - the node in which will be added a domain node
#    $domain    - name of domain
#	 $ips       - reference to @ip_pool of reseller
#    $refResRow - reference to hash of reseller's info
#

sub addDomainNode {
  my ($root,$domain,$ips,$refResRow) = @_;

  my ($rootDomain,$sql,$ptrRow,$item,$ip,$id,$idnName,
      $ptrHash,%custHash,$customer,$ptrSubdomains,$ptrDomains);

	my $utf8domain;

	my $nocontent = (exists $ptrArgs->{'no-content'})?1:0;

	if ($domain =~ /(^|\.)xn--[^.]+/) {
		$utf8domain = (exists $idn2Utf8cache{$domain}) ? $idn2Utf8cache{$domain} : &idnToUtf8($domain);
	} else {
		$utf8domain = $domain;
	}

## make anonymous array. need for return
	$ptrDomains = [];
	$ptrSubdomains = [];


  $rootDomain = XmlNode->new('domain');
  $rootDomain->setAttribute('name',$utf8domain, "UTF8");
  $root->{'ADDCHILD'}->($rootDomain);

  $sql = "SELECT k.* FROM kunden k, domains d WHERE (d.kunde=k.kunde) AND (d.domain='$domain')";
  unless ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
    $wrapDbh->{'FINISH'}->();
    &printToError( "Error: domain '$domain' is not found" );
    return 0;
  }
  unless($ptrHash = $wrapDbh->{'FETCHHASH'}->()){
    $wrapDbh->{'FINISH'}->();
    return 0;
  }
  %custHash = %{$ptrHash};
  $wrapDbh->{'FINISH'}->();

#
# IDN
#
	if( $majorVersion >= 3 ){
		my ($idnCharset,$domainId);
		$sql = "SELECT i.idn_name, i.charset, d.id FROM idn_aliases i, domains d ".
			"WHERE i.domain_id = d.id AND d.domain = '$domain'";
		if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			($idnName,$idnCharset,$domainId) = @{$wrapDbh->{'FETCHROW'}->()};

			if( $idnCharset && ( $idnCharset !~ /UTF-?8/i ) ) {
## translate to UTF8
				$idnName = &toUtf8($idnName, $idnCharset);
			}

			## use localized-name instead IDN-name (bug #43508)
			$rootDomain->setAttribute( 'name', $idnName, 'UTF8' ); ## don't translate to UTF-8 again

			$Domain2IDN{$domain} = $idnName; ## store maping domain -> idn-domain
		}
		$wrapDbh->{'FINISH'}->();
	}
#
# /IDN
#

	# get ip
	$ip = $custHash{'ip'};
	$ip =~ s/^\s+//;
	$ip =~ s/\s+$//;

	unless ($ip) {
		my $reseller = $custHash{'anbieter'};
		$sql = "SELECT standardip FROM anbieter WHERE anbieter = '$reseller'";
		if ($wrapDbh->{'EXECUTE'}->($sql)) {
			($ip) = @{$wrapDbh->{'FETCHROW'}->()};
			$ip =~ s/^\s+//;
			$ip =~ s/\s+$//;
		}
		$wrapDbh->{'FINISH'}->();
	}

	# Check that IP is in client's ip pool
	if (not $ip || not grep { "\Q$ip\E" } @{$ips}) {
		$ip = $admin{'standardip'};
	}
	$rootDomain->addChild(makeIpNode($ip));


	$item = XmlNode->new('status');
	my $node;

	if($custHash{'gesperrt'}) {
		$node = XmlNode->new('disabled-by', 'attributes' => {'name' => 'admin'});
	} else {
		$node = XmlNode->new('enabled');
	}

	$item->addChild($node);
	$rootDomain->addChild($item);


	$customer = $custHash{'kunde'};

#
# increase database's limit  by number of webShop's limit
#
	unless ( $nocontent ) {
		if ( $admin{'shops'} && $custHash{'maxshops'} ) {
			if ( $custHash{'maxshops'} > 0 ) {
				$custHash{'maxmysql'} += $custHash{'maxshops'}*2;
			} else {
				$custHash{'maxmysql'} = -1;
			}
		}

		$customer = $custHash{'kunde'};

		if( $custHash{'maxmysql'} > 0 || $refResRow->{'maxmysqllimit'} == 0 ){

			$sql = "SELECT COUNT(dbname) FROM mysql_datenbanken WHERE kunde='$customer'";
			if( $wrapDbh->{'EXECUTE'}->( $sql ) ){
				my ( $count ) = @{$wrapDbh->{'FETCHROW'}->()};
				$wrapDbh->{'FINISH'}->();

				if ( $admin{'shops'} ) {  ## include webShop's databases
					$sql  = "SELECT COUNT(shop_name) FROM shops WHERE kunde='$customer'";
					if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
						$count += $wrapDbh->{'FETCHROW'}->()->[0]*2; ## 2 databases for 1 webShop
						$wrapDbh->{'FINISH'}->();
					}
				}

				## limit great or equivalence then fact
				if(
					 ( $custHash{'maxmysql'} < $count  ) ||
					 ( ( $custHash{'maxmysql'} > -1 ) &&
						 ( $refResRow->{'maxmysqllimit'} == 0 )
					 )
					){
					$custHash{'maxmysql'} = $count;
				}
			}
			$wrapDbh->{'FINISH'}->();
		}

#
# correct limits
#
		my( $confixx, $confixxLimit, $count );
		foreach $confixx ( values %mapCustLimits ){

			next if $confixx eq 'maxmysql'; ## already prepared

			next unless $custHash{$confixx} > 0; ## skip unlimited

			$confixxLimit = $confixx.'limit';
			next unless exists $refResRow->{$confixxLimit};

			next if $refResRow->{$confixxLimit};
#
# oversell
#
			if( $confixx eq 'maxsubdomains' ){
				$sql = "SELECT COUNT(id) AS fact FROM domains WHERE domain LIKE '%.$domain'".
					" AND kunde='$customer'";

			}elsif( $confixx eq 'maxkb' ){
              if ($majorVersion > 3 || ($majorVersion == 3 && $minorVersion > 0)
                  || ($majorVersion == 3 && $minorVersion == 0 && $patchLevel >= 6)) {

				$sql = "SELECT kbhomedir+kbpop AS fact FROM kunden WHERE kunde='$customer'";
              } else {
                $sql = "SELECT kbhomedir AS fact FROM kunden WHERE kunde='$customer'";
              }

			}elsif( $confixx eq 'maxpop' ){
				$sql = "SELECT COUNT(account) AS fact FROM pop3 WHERE kunde='$customer'";

			}elsif( $confixx eq 'maxautoresponder' ){
				$sql = "SELECT COUNT(a.ident) AS fact FROM autoresponder a,email e ".
					" WHERE a.ident = e.ident AND e.domain = '$domain'";

			}elsif( $confixx eq 'maxmaillist' ){
				$sql = "SELECT COUNT(m.id) AS fact FROM maillist m, domains d ".
					" WHERE m.domain_id = d.id AND d.domain = '$domain'";

			}else{
				next;
			}

			next unless $wrapDbh->{'EXECUTE'}->( $sql );

			( $count ) = @{$wrapDbh->{'FETCHROW'}->()};
			$wrapDbh->{'FINISH'}->();

			$custHash{$confixx} = $count;

		}
#
# end correct limits
#
		&addLimits( $rootDomain, \%custHash, \%mapCustLimits );

		$item = &makeMailSystem($domain);
		if ( ref($item) =~ /XmlNode/ ) {
			$rootDomain->{'ADDCHILD'}->($item);
		}

		# DNS records (for versions starting from 2.x)
		if ($majorVersion >= 2) {
			my (@ns); ## default value for NS-records
			$sql = "SELECT pns,sns FROM anbieter WHERE anbieter='".$custHash{'anbieter'}."'";
			if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
				@ns = @{$wrapDbh->{'FETCHROW'}->()};
			}
			$wrapDbh->{'FINISH'}->();
			$ns[0] ||= $admin{'ip_pns'};
			$ns[1] ||= $admin{'ip_sns'};

			&addDNS ( $rootDomain, $domain, @ns );
		}
#
# user's databases
#
		&addUsersDatabase($rootDomain,$customer);
#
# end user's databases
#
	}

	my (%domainHash);

	$sql="SELECT * FROM domains WHERE domain='$domain'";
	if ($wrapDbh->{'EXECUTE'}->($sql)){
		if($ptrHash = $wrapDbh->{'FETCHHASH'}->()){
			%domainHash=%{$ptrHash};
		}
  }
  $wrapDbh->{'FINISH'}->();


#
# locked
#
	unless ( $nocontent ) {
#
# maillists
#
	  addMaillists($rootDomain, $domain, \%domainHash);

#
# end maillists
#

#
# ssl
#
		if ($domainHash{'cssl'}){
			$sql="SELECT crt,privatekey FROM cssl WHERE kunde='$customer'";
			if ($wrapDbh->{'EXECUTE'}->($sql)){
				if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					my($sslNode);
					$sslNode = XmlNode->new('certificate');
					$sslNode->addChild(XmlNode->new('certificate-data', 'content' => $ptrRow->[0]));
					$sslNode->addChild(XmlNode->new('private-key', 'content' => $ptrRow->[1]));
					$rootDomain->addChild($sslNode);
				}
			}
			$wrapDbh->{'FINISH'}->();
		}
#
# end ssl
#

#
# domain user
#
		$item = &makeDomainUserNode( \%custHash );
		if ( ref($item) =~ /XmlNode/ ) {
			$rootDomain->addChild($item);
		}

#
# end domain user
#

	} ## no content
#
# hosting
#
	my($hostingNode);

	if( $domainHash{'richtigedomain'} == 1 ||                                  ## domain
			( $domainHash{'richtigedomain'} == 0 && $domainHash{'pfad'} =~ /^\//)){  ## subdomain & no redirect

		my($plesk,$confixx,%attr);
		my($pathPrefix,$rePathPrefix,@excludeFiles);

		unless ( $nocontent ) {

			$hostingNode = XmlNode->new('phosting');

#
# sysuser
#
			$pathPrefix = $domainHash{'pfad'};
			$pathPrefix =~ s/^\///;

			$rePathPrefix = qr/^\/\Q$pathPrefix\E\// if $pathPrefix;

#
# check if there is ftp-account for this domain
#
			if ( $pathPrefix ) {
				$sql="SELECT * FROM ftp WHERE kunde='$customer' AND pfad='$pathPrefix'";
				if ($wrapDbh->{'EXECUTE'}->($sql)){
					my $ptrFtp = $wrapDbh->{'FETCHHASH'}->();
					%attr=('NAME'=>$ptrFtp->{'account'},
								 'PASSWORD'=>$ptrFtp->{'longpw'},
								);
				}
				$wrapDbh->{'FINISH'}->();
			}
			unless(%attr){
				%attr = ( 'NAME' => $domainHash{'kunde'},
									'PASSWORD' => $custHash{'longpw'},
							);
				if( $custHash{'maxkb'} > 0 ) {
					$attr{'QUOTA'} = $custHash{'maxkb'} * 1024; ## translate to bytes
				}
				if( $custHash{'shell'} ) {
					$attr{'SHELL'} = $stdShell || '/bin/sh';
				}
			}
			$item = &makeSysuserNode(\%attr);
			$hostingNode->addChild($item);
#
# end sysuser
#

#
# scripting
#
			$item = &makeScriptingNode( \%mapCustScripting, \%custHash );
			$hostingNode->addChild($item);
#
# end scripting
#

#
# FronPage user
#
			if($domainHash{'frontpage'}){
				$sql = "SELECT benutzer,passwort FROM frontpage WHERE domain='$domain'";
				if($wrapDbh->{'EXECUTE'}->($sql)){
					if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
						$item = XmlNode->new('fpuser', 'attributes' => {'name' => $ptrRow->[0]});
						$hostingNode->addChild($item);
						$item->addChild(&makePasswordNode($ptrRow->[1],'plain'));
					}
				}
				$wrapDbh->{'FINISH'}->();
			}
#
# end FronPage user
#

#
# .htpasswd
#

			if($custHash{'pwschutz'}){
				my (%pdirs,$path,$parentID,$pdirNode,$ptrArr,$title);

				$sql="SELECT ident,pfad,bereich FROM pwschutz WHERE kunde='$customer'";
				if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
					while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
						$path = $ptrRow->[1];
						if($pathPrefix){
							unless( $path =~ s/$rePathPrefix/\//){
								next;   ## not subdir
							}
						}
						$pdirs{$path} = [ $ptrRow->[0], $ptrRow->[2] ];
					}
				}
				$wrapDbh->{'FINISH'}->();

				while( ($path,$ptrArr) = each(%pdirs) ) {
					( $parentID, $title ) = @{$ptrArr};
					if($pathPrefix){
						unless ( $path =~ s/$rePathPrefix// ) {
							next;  ## not subdir
						}
					}
					$pdirNode = XmlNode->new('pdir', 'attributes' => {'name' => $path, 'title' => $title});
					$hostingNode->addChild($pdirNode);
					$sql="SELECT login,longpw FROM users WHERE parent=$parentID";
					if($wrapDbh->{'EXECUTE'}->($sql)){
						while( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
							$item = XmlNode->new('pduser', 'attributes' => {'name' => $ptrRow->[0]});
							$item->addChild(&makePasswordNode($ptrRow->[1]));
							$pdirNode->addChild($item);
						}
					}
					$path =~ s/^\///;
					$path .= '/' if $path;
					push @excludeFiles,($path.'.htaccess',$path.'.htpasswd');

					$wrapDbh->{'FINISH'}->();
				}
			}
#
# end .htaccess
#
		}

		my ($ptrAccounts);
		( $ptrSubdomains, $ptrAccounts ) = &getSubdomains( $domain, \%domainHash );


		unless ( $nocontent ) {

#
# translate ftp-accounts to webuser of main domain
#
			if($domainHash{'richtigedomain'} && ref($ptrAccounts)=~/HASH/){
				my ($account,$path);
				$sql="SELECT account,longpw,pfad FROM ftp WHERE kunde='$customer'";
				if($wrapDbh->{'EXECUTE'}->($sql)){
					my ($webuserNode,$ftpDump);
					while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
						$account = $ptrRow->[0];
						$path = $ptrRow->[2];
						if($pathPrefix){
							unless($path =~ s/$rePathPrefix//){
								next;   ## not subdir
							}
						}
						next if exists $ptrAccounts->{$account}; ## already there is a domain with the ftp-account
						$webuserNode = XmlNode->new('webuser');
#
# removed
#
#	$webuserNode->{'ATTRIBUTE'}->('name',$path);
#
# end removed. Plesk does not support this attribute
#
						my $uniqName = makeUniqName($account);

                        $item = &makeSysuserNode($uniqName, $ptrRow->[1]);
						$webuserNode->addChild($item);

						$ftpDump = &makeDumpFile("$dumpDir/$uniqName","$user_homeDir/$customer/html/".$ptrRow->[2],'.');

						$webuserNode->setAttribute('cid',$ftpDump) if ($ftpDump);
						$hostingNode->addChild($webuserNode);

						$item = &makeScriptingNode(\%mapCustScripting,\%custHash);
						$webuserNode->addChild($item);
					}
				}
				$wrapDbh->{'FINISH'}->();
			}
#
# end translate ftp-accountys to webuser
#
		}

#
# add subdomains
#
		my ( $reSubDomain, $name );
		$reSubDomain = qr/^(.+)\.\Q$domain\E$/; ## extract name of subdomain from domain's name

    while (my($subdomain,$ptrAttrHash) = each(%{$ptrSubdomains})){

      if ( $subdomain =~ /$reSubDomain/ ) {
				$name = $1;
				unless ( $nocontent ) {
					unless ( $name =~ /\*/ ) {  ## skip wildcard-domain

						$item = &makeSubdomainNode( $name, $domain, $ptrAttrHash, \%custHash );

						if ( ref($item) =~ /XmlNode/ ) {
							$hostingNode->addChild($item);
						}
					}
				}

      } else {
				delete ( $ptrSubdomains->{$subdomain} );
			}
    }
#
#  end add subdomains
#


		unless ( $nocontent ) {
#
# attributes of physical hosting
#
			if($pathPrefix){
				my $rePrefix = qr/^\Q$pathPrefix\E\//;
				my @excludeEntry = grep{/$rePrefix/} @excludeFiles; ## select files only from $pathPrefix
				$dumpFile = &makeDumpFile("$dumpDir/$domain.docroot",
																	"$user_homeDir/$customer/html/$pathPrefix",
																	['.'],
																	\@excludeEntry
																 );
				$hostingNode->setAttribute($domainHash{'cssl'}?'cid_docroot_ssl':'cid_docroot',$dumpFile) if $dumpFile;

			}else{
				push @excludeFiles,'cgi-bin';
				$dumpFile = &makeDumpFile("$dumpDir/$domain.docroot",
																	"$user_homeDir/$customer/html",
																	['.'],
																	\@excludeFiles
																 );
				$hostingNode->setAttribute($domainHash{'cssl'}?'cid_docroot_ssl':'cid_docroot',$dumpFile) if $dumpFile;

				$dumpFile = &makeDumpFile("$dumpDir/$domain.cgi","$user_homeDir/$customer/html/cgi-bin");
				$hostingNode->setAttribute('cid_cgi',$dumpFile) if $dumpFile;
			}

			$hostingNode->setAttribute('fp',$domainHash{'frontpage'}?'true':'false');
			$hostingNode->setAttribute('webstat',$custHash{'statistik'}?'true':'false');
			$hostingNode->setAttribute('errdocs',$custHash{'fehlerseiten'}?'true':'false');
			$hostingNode->setAttribute('wu_script', 'true');
#
# end attributes of physical hosting
#
		} ## no content

#
# translate subdomain to domain
#
		my ($list);

		$ptrSubdomains = [keys %{$ptrSubdomains}];  ## make anonymous array. need for return
    $list=join(',',map {"'$_'"} @{$ptrSubdomains}); ## list of prepared subdomains

    $sql="SELECT domain FROM domains WHERE (richtigedomain=0) AND (kunde='$customer')".
      " AND (domain like '\%.$domain')";
    if($list){
      $sql.=" AND NOT (domain in ($list))";
    }
    if($wrapDbh->{'EXECUTE'}->($sql)){
			my ($subdomain,$name);
      while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$subdomain = $ptrRow->[0];
				if ( $subdomain =~ /$reSubDomain/ ){  ## subdomain
					$name = $1;
					unless ( $name =~ /\*/ ) { ## exclude wildcard-subdomains
						push @{$ptrDomains}, $subdomain;
					}
				}
      }
    }
    $wrapDbh->{'FINISH'}->();

#
# end translate subdomain to domain
#

  }elsif( ( $domainHash{'richtigedomain'} == 0 ) &&
		 !( $domainHash{'pfad'} =~ /^\// ) ){
#
# redirect
#
		unless ( $nocontent ) {
			$hostingNode = XmlNode->new('shosting', 'content' => $domainHash{'pfad'});
		}
  }

	unless ( $nocontent ) {
		if(ref($hostingNode)=~/XmlNode/){
			$rootDomain->addChild($hostingNode);
		}
	} ## no content
#
# end hosting
#

#
# return list of subdoamin where are translated to domain & list of prepared subdomains
#
  return ($ptrDomains,$ptrSubdomains);

}

#
# end addDomainNode
#

sub makeDomainUserNode {

	my ($custHash) = @_;

	my $root = XmlNode->new('domainuser');

	if ( ref($custHash) =~ /HASH/ ) {

		my $contact = "";
		$contact = $custHash->{'firstname'} if $custHash->{'firstname'};
		$contact .= ($contact ? " " : "") . $custHash->{'name'} if $custHash->{'name'};

		$root->setAttribute( 'contact', $contact) if $contact;

		$root->setAttribute('status',$custHash->{'gesperrt'}?'false':'true');
		#  $root->{'ATTRIBUTE'}->('account',$custHash->{'kunde'});
		$root->addChild(&makePasswordNode($custHash->{'longpw'}));

		&addPinfo( $root, $custHash, \%mapUserPinfo);

		unless ( exists ( $mapCustPermis{'make_dumps'} ) ) {
			$mapCustPermis{'make_dumps'} = $backup_off? 0: 1;
		}

		# default value, as confixx has no the corresponding option
		$mapCustPermis{'multiple-sessions'} = 1;

		&addPermissions( $root, $custHash, \%mapCustPermis );

	}

	return $root;
}

#
# dns records
#
sub addDNS {
	my ($root, $domain, @ns) = @_;

	my ($sql, $ptrRow, $cnt, $ptrHash, $webmail);

	return undef unless exists $admin{'dns'}; ## Premium 1.0.* has not dns

	return -1 unless $admin{'dns'};

	my $dnsNode = XmlNode->new('dns', 'attributes' => {'enabled' => 'true'});
	$root->{'ADDCHILD'}->($dnsNode);

	$cnt = 0;
       $sql = "SELECT webmail FROM kunden AS k, domains AS d WHERE k.kunde = d.kunde AND d.domain = '$domain'";
       if ($wrapDbh->{'EXECUTE'}->($sql)) {
         $ptrHash = $wrapDbh->{'FETCHHASH'}->();
         if ($ptrHash->{'webmail'} == 1){
           $webmail = 'true';
         }
       }
        $wrapDbh->{'FINISH'}->();

	$sql = "SELECT zonefile FROM dns WHERE domain='$domain'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
	  my ($line, @fields, $type, $i, $dst, $src, $opt, $soa);
	  $ptrRow = $wrapDbh->{'FETCHROW'}->();

	  foreach $line (split(/\n/, $ptrRow->[0])) {
			next unless $line;
			$cnt++;
			@fields = split(' ', $line);
			if (@fields > 2) {
				$src = $fields[0];
				$dst = undef;
				$opt = undef;
				for($i = 3; $i > 0; $i--) {
					$type = $fields[$i];
					if($type =~ /^(A|NS|CNAME|PTR)$/i) {
						$dst = $fields[$i+1];
						last;
					} elsif ($type =~ /^MX$/i) {
						$dst = $fields[$i+2];
						$opt = $fields[$i+1];
						last;
					}
				}

				if ($dst) {

					if ( $type eq 'NS' ) {
						if ( $dst eq '.' ) {
							$dst = shift( @ns);
						}
			# Some Confixxes are buggy and have IP followed by the
			# dot in the NS records
						if ( $dst =~ /^(\d+\.\d+\.\d+\.\d+)\.?$/ ) {  ## is an IP
							$dst = $1; #strip dot from the end of IP
                                                       if ($webmail) {
                                                         makeDnsRecord($dnsNode, 'A', "webmail.$src", $dst);
                                                       }
							makeDnsRecord($dnsNode, 'A', "ns.$src", $dst);
							$dst = "ns.$src";
						}
						if ( $dst ) {
							makeDnsRecord($dnsNode, 'NS', $src, $dst );
						}

					} else { ## all other types
						makeDnsRecord($dnsNode, $type, $src, $dst, $opt) unless $src=~/^#.*/;
					}

				}
			}
		}
	}

	$wrapDbh->{'FINISH'}->();
	return $cnt;
}

sub makeDnsRecord {
  my ($root, $type, $src, $dst, $opt) = @_;

  my $item = XmlNode->new('dnsrec', 'attributes' => { 'type' => $type, 'src' => $src, 'dst' => $dst});
  $item->setAttribute('opt', $opt) if ($opt);
  $root->addChild($item);
}

#
# end dns records
#




#
# maillist
#

sub addMaillists {
  my ($root, $domain, $ptrDomainHash) = @_;

  return if $majorVersion < 3;

  my $domainId = $ptrDomainHash->{'id'};
  unless ($domainId) {
	printToError("Error: sub addMaillist: domain id is not found");
	return;
  }

  my @ids;
  my $sql = "SELECT id FROM maillist WHERE domain_id=$domainId ORDER BY id";
  if ($wrapDbh->{'EXECUTE'}->($sql)) {
	my $ptrRow;
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	  push @ids, $ptrRow->[0];
	}
  }
  $wrapDbh->{'FINISH'}->();

  my $maillistsNode = XmlNode->new('maillists',
							  children => [Status::make($Status::ENABLED)]);

  my $maillistId;
  foreach $maillistId (@ids) {
	$sql = "SELECT * FROM maillist WHERE id=$maillistId";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
	  my $ptrMaillist = $wrapDbh->{'FETCHHASH'}->();

	  my $status = $Status::ENABLED;
	  $status = $Status::ADMIN if $ptrMaillist->{'resperrt'};

	  my $rootMaillist = XmlNode->new('maillist',
								 attributes => {'name', $ptrMaillist->{'name'}},
								 children => [Status::make($status),
											  XmlNode->new('owner',
													  'content' =>$ptrMaillist->{'owner_mail'})]);

	  if ($ptrMaillist->{'pwd'}) {
		$rootMaillist->addChild(makePasswordNode($ptrMaillist->{'pwd'}, 'plain'));
	  }

	  if ($majordomo_ldir && (-d $majordomo_ldir)) {
		my $recipientsFile = "$majordomo_ldir/$domainId/lists/" . $ptrMaillist->{'name'};
		if (-T $recipientsFile) {
		  if ( open(LIST,"<$recipientsFile") ) {
			while (<LIST>) {
			  chomp;
			  next unless $_;
			  $rootMaillist->addChild(XmlNode->new('recipient', content => $_));
			}
			close(LIST);
		  } else {
			printToError("Error: sub addMaillist: unable to open '$recipientsFile' for read: $!\n");
		  }
		}
	  }
	  $wrapDbh->{'FINISH'}->();

	  $maillistsNode->addChild($rootMaillist);
	}
  }

  $root->addChild($maillistsNode);
}

#
# end maillist
#


sub addFreeMailBoxes {
	my ( $root, $customer ) = @_;

	unless(ref($root)=~/XmlNode/){
		&printToError("Error: sub addFreeMailBoxes: wrong paraneters");
		return;
	}

	my $ret = 0;

  unless(exists ($preparedCustomers{$customer})){
    $preparedCustomers{$customer}={};
  }

  if(exists ($preparedCustomers{$customer}->{'mbox'})){
		return $ret;
	}

	my($sql,%mbox,@idents,$ptrRow,$ptrHash);

	$sql = "SELECT * FROM email WHERE kunde='$customer'";

  if ( $wrapDbh->{'EXECUTE'}->($sql) ) {

		my $oldVer; # ver. <= 3.0.8 flag
		my $reMbox = qr/^[^@]+\d+p\d+$/;

		while($ptrHash = $wrapDbh->{'FETCHHASH'}->()){

			if(!defined($oldVer)) {
				$oldVer = exists $ptrHash->{'pop3'};
			}

			if( $oldVer ){

				if( $ptrHash->{'pop3'} =~ /$reMbox/ ){
					$mbox{$ptrHash->{'pop3'}} = 1;
				}

				map{ $mbox{$_} = 1 } grep{ /$reMbox/ } split( /:/, $ptrHash->{'pop3x'} );

			}else{
				push @idents, $ptrHash->{'ident'};
			}

		}

		$wrapDbh->{'FINISH'}->();

		if( @idents ){

			$sql = "SELECT pop3 FROM email_forward ".
				"WHERE email_ident IN (".join(',',@idents).
					") AND kunde='$customer' GROUP BY pop3";

			if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

				while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					if( $ptrRow->[0] =~ /$reMbox/ ){
						$mbox{$ptrRow->[0]} = 1;
					}
				}

				$wrapDbh->{'FINISH'}->();
			}
		}
	}

	$sql = "SELECT account, longpw FROM pop3 WHERE kunde='$customer' ORDER BY number";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {

		while( $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
			my ($account, $longpw) = @{$ptrRow};
			next if exists $mbox{$account}; ## skip mbox with email
			$ret++;
			my $rootUser = &makeMBoxNode($account, $longpw, $customer);
			$root->addChild($rootUser);
		}
	}
	$wrapDbh->{'FINISH'}->();

	$preparedCustomers{$customer}->{'mbox'} = 1;

	return $ret;
}

#
# database
#

sub addUsersDatabase {

	my ($root,$customer) = @_;

	unless(ref($root)=~/XmlNode/){
		&printToError("Error: sub addUsersDatabase: wrong paraneters");
		return;
	}

	my ( $itemDbUser, $nameUser, $accesshosts );
	my $ret = 0;

  unless(exists ($preparedCustomers{$customer})){
    $preparedCustomers{$customer}={};
  }

  unless(exists ($preparedCustomers{$customer}->{'db'})){
    my ($nameDb,$nodeDb,$sql);

    $sql = "SELECT dbname FROM mysql_datenbanken WHERE kunde='$customer'";

    if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

      my ($ptrRow,$nodeDB,$dumpDb,$password,$nodeUser);

      while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$nameDb = $ptrRow->[0];

				&printToLog("Dump user's mysql '$nameDb'");

				$nodeDb = XmlNode->new('database', 'attributes' => {'name' => $nameDb, 'type' => 'mysql'});
                $nodeDb->setAttribute('version', Db::MysqlUtils::getVersion());

				$dumpDb = &makeDumpDb($nameDb,'mysql',
															undef,$mysqlUserPw,undef);

				$nodeDb->setAttribute('cid',$dumpDb);

				$root->addChild($nodeDb);

				$accesshosts = getAccessHosts($nameDb);

				$itemDbUser = &addDbUserConfixx( $nodeDb,$customer,'', $accesshosts);

				&checkUniqueDbUser( $customer,$itemDbUser,$nameDb );

				$ret++;
      }
    }
    $wrapDbh->{'FINISH'}->();
    $preparedCustomers{$customer}->{'db'} = 1;
  }
#
# Premium 1.* - webShop
#
	if ( exists( $admin{'shops'}) && $admin{'shops'} ) {
		unless( exists ( $preparedCustomers{$customer}->{'shop'} ) ) {
			my ($nameDb,$nodeDb,$sql);

			$sql = "SELECT shop_name, password FROM shops WHERE kunde='$customer'";

			if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

				my ($ptrRow,$nodeDB,$dumpDb,$password,$passwordNode,$nodeUser,$shopUser);

				while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$shopUser = $nameDb = $ptrRow->[0];
					$password = $ptrRow->[1];
					$passwordNode = &makePasswordNode( $password,'plain' );


					&printToLog("Dump user's webShop '$nameDb'");

#
# shop_<customer_<N>
#
					$nodeDb = XmlNode->new('database', 'attributes' => {'name' => $nameDb, 'type' => 'mysql', 'version' => Db::MysqlUtils::getVersion()});

					$dumpDb = &makeDumpDb($nameDb,'mysql',
																$shopUser,$password,undef);

					$nodeDb->setAttribute('cid',$dumpDb);

					$root->addChild( $nodeDb );

					$accesshosts = getAccessHosts($nameDb);

					$itemDbUser = &addDbUserConfixx( $nodeDb,$shopUser,$passwordNode,$accesshosts );

					&checkUniqueDbUser( $shopUser,$itemDbUser,$nameDb );

					$ret++;

#
# design_<customer>_<N>
#
					$nameDb =~ s/^shop_/design_/;

					$nodeDb = XmlNode->new('database', 'attributes' => { 'name' => $nameDb, 'type' => 'mysql', 'version' => Db::MysqlUtils::getVersion()});

					$dumpDb = &makeDumpDb($nameDb,'mysql',
																$shopUser,$password,undef);

					$nodeDb->setAttribute('cid',$dumpDb);

					$root->addChild( $nodeDb );

					$accesshosts = getAccessHosts($nameDb);

					$itemDbUser = &addDbUserConfixx( $nodeDb,$shopUser,$passwordNode,$accesshosts );

					&checkUniqueDbUser( $shopUser,$itemDbUser,$nameDb );


					$ret++;
				}
      }

			$wrapDbh->{'FINISH'}->();

			$preparedCustomers{$customer}->{'shop'} = 1;
		}
	}
#
# end webShop
#
	return $ret;
}

my %dbUsers;

sub checkUniqueDbUser {
	my ($nameUser,$itemDbUser,$nameDb) = @_;

	my ( $i );

	if ( exists( $dbUsers{$nameUser} ) ) {
#
# make unique name
#
		$i = $dbUsers{$nameUser}+1;
		my $newName = $nameUser.'_'.$i;
		while ( exists( $dbUsers{$newName} ) ) {
			$i++;
			$newName = $nameUser.'_'.$i;
		}
		$nameUser = $newName;

		if ( ref($itemDbUser) =~ /XmlNode/ ) {
			$itemDbUser->{'ATTRIBUTE'}->( 'name', $nameUser );
		}

	}

	$dbUsers{$nameUser} = $i;

	return $nameUser;

}


#
# end databse
#



#
# make list of subdomains
#
sub getSubdomains {
	my($domain,$ptrDomainHash) = @_;

	my ($subdomain,$ptrAttrHash,$name,$reSubDomain,$sql);
	my ($pathPrefix,$rePathPrefix,$ptrSubdomains,$ptrAccounts,$customer,@tmp);
	my ($account,$path,@subsubdomains,$ptrRow);

	$pathPrefix = $ptrDomainHash->{'pfad'};
	$pathPrefix =~ s/^\///;

	$rePathPrefix = qr/^\/\Q$pathPrefix\E\// if $pathPrefix;

	$reSubDomain = qr/^(.+)\.\Q$domain\E$/;

	$ptrSubdomains = {};
	$ptrAccounts = {};
	$customer = $ptrDomainHash->{'kunde'};

	$sql = "SELECT f.account,f.longpw,d.pfad,d.domain FROM domains d ".
		" LEFT JOIN ftp f ON (f.kunde=d.kunde) AND (f.pfad = SUBSTRING(d.pfad,2)) ".
			" WHERE (d.kunde='$customer') AND (d.domain like '\%.$domain') AND (d.richtigedomain = 0)";
#
# 'domains.pfad' begins with '/', 'ftp.pfad' does not
#

	if($wrapDbh->{'EXECUTE'}->($sql)){
		while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
			$path = $ptrRow->[2];
			$path =~ s/^\///;  ## remove first slash

			if ( $pathPrefix ) {
				unless ( $path =~ /$rePathPrefix/ ) {
					next;   ## not subdir
				}
			}
			$subdomain = $ptrRow->[3];

			if( $subdomain =~ /$reSubDomain/ ) {
				$ptrSubdomains->{$subdomain} = {
																				'NAME' => $1,
																				'PATH' => "$user_homeDir/$customer/html/$path",
																			 };
			}


			if ( $account = $ptrRow->[0] ) {
				$ptrAccounts->{$account} = 1; ## all ftp-accounts where matchs with subdomain

				$ptrSubdomains->{$subdomain}->{'ACCOUNT'} = $account;
				$ptrSubdomains->{$subdomain}->{'PASSWORD'} = $ptrRow->[1];
				$ptrSubdomains->{$subdomain}->{'PATH'} = "$user_homeDir/$customer/html/$path";
			}
		}
	}
	$wrapDbh->{'FINISH'}->();


#
# translate subdomain having mail to domain
#
	my $list = join(',',map {"'$_'"} keys %{$ptrSubdomains});
	if ( $list ) {
		$sql = "SELECT domain FROM email WHERE domain IN ($list)";
		if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
			my ($emailDomain);
			while ($ptrRow=$wrapDbh->{'FETCHROW'}->()){
				$emailDomain = $ptrRow->[0];
## translate subdomain to domain if there is an email
				&removeFromSubdomains( $emailDomain, $ptrSubdomains );
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

#
# translate subdomain with redirect to domain
#
	$list = join( ',', map {"'$_'"} keys %{$ptrSubdomains} );
	if( $list ) {
		$sql = "SELECT domain, pfad FROM domains WHERE (richtigedomain=0) AND ".
			"NOT (pfad LIKE '/\%') AND (domain IN ($list))";
		my ($redirectDomain);
		if( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			while ( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$redirectDomain = $ptrRow->[0];
## translate subdomain to domain if it is a redirect
				&removeFromSubdomains( $redirectDomain, $ptrSubdomains );
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

	return ( $ptrSubdomains, $ptrAccounts );

}

#
# remove domain with it subdomain
#
sub removeFromSubdomains{
	my ( $domain, $ptrHash ) = @_;
	my $reSubdomain = qr/^(.+\.)?\Q$domain\E$/;
	foreach ( my $subdomain = keys %{$ptrHash} ) {
		if( $subdomain =~ /$reSubdomain/ ) {
			delete $ptrHash->{$subdomain};
		}
	}
}

#
# end make list of subdomains
#



#
# mail system
#

sub makeMailSystem {

	my ($domain) = @_;
	my ($sql,$rootMail,$prefix,%box,%redir,@dest,$pop,$rootUser,
			$count,$i,$ptrPrefixes,$ptrHash,$ptrRow,$item,$redirect,$account,
			@prefixes,%group,$catch_all,%alias,$customer);

	my $mailsystem;	# mailsystem presented flag
	my @buf;		# copy of email information from database
	my $oldVer;		# ver. <= 3.0.8 flag

	# Lookup email information
  $sql="SELECT * FROM email WHERE domain='$domain' ORDER BY prefix";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {

		$mailsystem = 1;
#		$oldVer = grep{/^pop3/} $wrapDbh->{'FIELDS'}->(); ## ver. <= 3.0.8
		while ($ptrHash = $wrapDbh->{'FETCHHASH'}->()) {
			push @buf,{%{$ptrHash}};
			$customer ||= $ptrHash->{'kunde'};

			if(!defined($oldVer)) {
				$oldVer = exists $ptrHash->{'pop3'};
			}
		}
	}
	$wrapDbh->{'FINISH'}->();

	# Determine mailsystem presense by domain name and pop3
	# (there may be no records in email table, but 'free' mailboxes
	# may be presented)
	if (not $mailsystem) {

		$sql = "SELECT d.kunde FROM domains d, pop3 p ".
			"WHERE d.domain='$domain' AND d.richtigedomain=1 AND d.kunde=p.kunde LIMIT 1";
		if ($wrapDbh->{'EXECUTE'}->($sql)) {
			$ptrRow = $wrapDbh->{'FETCHROW'}->();
			$customer = $ptrRow->[0];
			$mailsystem = 1;
		}
		$wrapDbh->{'FINISH'}->();
	}

	# Mailsystem is not found on domain
	if (not $mailsystem) {
		return;
	}

    $rootMail = XmlNode->new('mailsystem');

    $rootMail->addChild(XmlNode->new('status', 'children' => [XmlNode->new('enabled')]));

    foreach  $ptrHash (@buf) {

      $prefix = $ptrHash->{'prefix'};

#
# exclude catch-all from mailusers
#
			unless ( $prefix =~ /\*/ ) {
				push @prefixes,$prefix;
			} else {
				$catch_all = $prefix;
			}

#
# get list of destination
#
			if( $oldVer ){
      @dest = ( $ptrHash->{'pop3'} );
      push @dest, split( /:/,$ptrHash->{'pop3x'} );

			} else {
				my $ident = $ptrHash->{'ident'};
				$sql="SELECT pop3 FROM email_forward WHERE email_ident=$ident ORDER BY id";
				if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
					@dest = ();
					while( my $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
						push @dest, $ptrRow->[0];
					}
				}
				$wrapDbh->{'FINISH'}->();

			}

      foreach $pop ( @dest ) {

				if ($pop =~ /^[^@]+\d+p\d+$/ ) { ## <user_prefix><N>p<M>  - web2p1
					push @{$box{$pop}},$prefix; ## all emails for this mail box
					push @{$alias{$prefix}},$pop; ## all aliases for this prefix
					push @{$redir{$prefix}}, $pop.'@'.$domain;
				} elsif ( $pop =~ /\@/ ){
					push @{$redir{$prefix}}, $pop; ## prefix is unique in the domain

				}
      }
    }

	foreach $account (sort keys %box) {

		next if ( $account =~ /\*/ ); ## skip catch_all

		my $longpw = '';

		$sql="SELECT longpw FROM pop3 WHERE account='$account'";

		if ($wrapDbh->{'EXECUTE'}->($sql)){
			$ptrRow = $wrapDbh->{'FETCHROW'}->();
			$longpw = $ptrRow->[0];
		}
		$wrapDbh->{'FINISH'}->();

		$rootUser = &makeMBoxNode( $account, $longpw, $domain );
		$rootMail->addChild($rootUser);
	}

	foreach $prefix (sort keys %redir ) {

		next if ( $prefix =~ /\*/ ); ## skip catch_all

		foreach $redirect ( @{$redir{$prefix}} ) {
			next if ( $redirect =~ /\*/ ); ## skip catch_all
			push @{$group{$prefix}},split( /\s*,\s*/,$redirect );
		}

		if ( 1 == @{$group{$prefix}} ) { ## only one redirect - alias
			($redirect) = @{$group{$prefix}};

		} else { ## more thet one redirect - mailgroup
			$redirect = undef;
		}

		$rootUser = XmlNode->new('mailuser', 'attributes' => {'name' => $prefix, 'mailgroup-enabled' => $redirect ? 'false' : 'true'});

		$rootMail->addChild($rootUser);

		if ($redirect) {

          $rootUser->addChild(XmlNode->new('redirect', 'content' => $redirect));

		} else {
			foreach $pop ( @{$group{$prefix}} ) {
				$rootUser->addChild(XmlNode->new('mailgroup-member', 'content' => $pop));
			}
		}

		&addAutoresponders( $rootUser, $domain, $prefix );
	}

	&addFreeMailBoxes( $rootMail, $customer ) if $rootMail && $customer;

	if ( $catch_all ) {
		if ( ref($redir{$catch_all}) =~ /ARRAY/ ) {
			foreach my $rdr ( @{$redir{$catch_all}} ) {
				if ( $rdr ) {
					$redirect = $rdr;
					last;
				}
			}
		} else {
			$redirect = $redir{$catch_all};
		}
		unless( $redirect ) {
			if ( $redirect = $box{$catch_all} ) {
				$redirect .= '@'.$domain;
			}
		}
		if ( $redirect ) {
			$rootMail->addChild(XmlNode->new('catch-all', 'content' => $redirect));
		}
	}

	return $rootMail;
}

sub makeMBoxNode {

	my($account,$longpw,$domain) = @_;

	my $rootUser = XmlNode->new('mailuser', 'attributes' => {'name' => $account, 'mailgroup-enabled' => 'false'});

	my ($item);

	if( $longpw ) {
		if( $item = &makePasswordNode( $longpw ) ) {
			$rootUser->addChild($item);
		}
	}

	if ( $majorVersion > 2 ){  ## for Confixx 3 and later
		addMailuserPermissionNode($rootUser, 'multiple-sessions', 'true');
		addMailuserPermissionNode($rootUser, 'cp-access', 'true');
	}

	$item = &makeMailboxNode($account, $domain);
	$rootUser->{'ADDCHILD'}->($item);

	return $rootUser;

}
#
# end mail system
#



sub addDbUserConfixx {
  my ($rootNode, $customer, $passwordNode, $accesshosts) = @_;

  my $userItem = &addDbUser($rootNode, $customer, $wrapUserMysql, $passwordNode, $accesshosts);

	return $userItem;

}

#
# makeSubdomainNode  - create XML-node for subdomain
#
# argumets:
#      $name        - name of subdomain (without '.')
#      $domain      - domain
#      $ptrAttrHash - pointer to hash with attributes of subdomain
#      $ptrScriptingHash - pointer to hash with parameters of scripting
#
# return:
#      $subdomNode  - pointer to new XML-node
#

sub makeSubdomainNode {
  my( $name, $domain, $ptrAttrHash, $ptrScriptingHash ) = @_;
  my ($subdomNode,$item,$path,$dumpFile);
  unless( ref($ptrAttrHash) =~ /HASH/ ) {
    $ptrAttrHash = {};
  }
  unless( ref($ptrScriptingHash) =~ /HASH/ ) {
    $ptrScriptingHash = {};
  }

  $subdomNode = XmlNode->new( 'subdomain' , 'attributes' => {'name' => $name});

  if ( $path = $ptrAttrHash->{'PATH'}){
    if($dumpFile = &makeDumpFile("$dumpDir/$name.$domain",$path,'.')){
      $subdomNode->setAttribute( 'cid_docroot', $dumpFile );
    }
  }

	if ( keys %{$ptrAttrHash} ) {
		$item = &makeSysuserNode( $ptrAttrHash );
		$subdomNode->addChild( $item );
	}

  $item = &makeScriptingNode(\%mapCustScripting,$ptrScriptingHash);
  $subdomNode->addChild( $item );

  return $subdomNode;
}

#
# create system user node
# check if there was already this account
# & add a suffix to make an unique account
#
my %sysUsers;

sub makeUniqName {
  my $name = shift;

  return $name if ref($name) =~ /HASH/;
 
  $name =~ s/\./_/g;
  if ( exists( $sysUsers{$name} ) ) {
			my $clon = 1;
            while(exists($sysUsers{$name})){
				if($name =~ /(.*)c(\d+)$/){
					$name = $1;
					$clon = $2;
					$clon++;
				}
				$name .= "c$clon";
			}
		}
  $sysUsers{$name} = 1;

  return $name;

}

sub makeSysuserNode {

  my ($account,$password,$pswdType,$quota,$shell)=@_;

  my ($ptrHash,$item);

  if ( ref($account) =~ /HASH/ ) {
    $ptrHash = $account;
    $account = makeUniqName($ptrHash->{'ACCOUNT'}||$ptrHash->{'NAME'});
    $password = (exists $ptrHash->{'PASSWORD'}) ? $ptrHash->{'PASSWORD'} : '';
    $pswdType = $ptrHash->{'PSWDTYPE'};
    $shell = $ptrHash->{'SHELL'};
    $quota = $ptrHash->{'QUOTA'};
  }
	if ( $account ) {

		$item = XmlNode->new('sysuser', 'attributes' => {'name' => $account});
		if($quota){
			$item->setAttribute('quota',$quota);
		}
		if($shell){
			$item->setAttribute('shell',$shell);
		}

		$item->addChild( &makePasswordNode($password,$pswdType) );

	}

  return $item;
}

sub makeScriptingNode {
  my $ptrMapHash = shift;
  my $ptrValueHash = shift;

  my ($plesk,$confixx,$value);

  my $item = XmlNode->new('scripting');
  if(ref($ptrValueHash)=~/HASH/ && ref($ptrMapHash)=~/HASH/){
    while (($plesk,$confixx)=each(%{$ptrMapHash})){
			if ( $confixx =~ /^\d+$/ ) {
				$value = $confixx;
			}	elsif( exists ( $ptrValueHash->{$confixx} ) ) {
				$value = $ptrValueHash->{$confixx} || 0;
			} else {
				$value = undef;
			}
			if ( defined ( $value ) ) {
				$item->setAttribute($plesk,$value?'true':'false');
      }
    }
  }
  return $item;
}

sub addAutoresponders {
  my ($root,$domain,$prefix,@prefixes)=@_;

  my($list,$sql,$ptrHash,$item,$name,$value);

	if( ref($prefix) =~ /ARRAY/ ){
		@prefixes = @{$prefix};
	}else{
		push @prefixes, $prefix;
	}
	$list = join( ',', map{"'".$_.'@'.$domain."'"} @prefixes );


    $sql = "SELECT * FROM autoresponder WHERE absenderemail in ($list)";
    if ($wrapDbh->{'EXECUTE'}->($sql)){

		my $autorespondersNode = XmlNode->new( 'autoresponders', 'attributes' => {'enabled' => 'true'} );

      while ($ptrHash=$wrapDbh->{'FETCHHASH'}->()){
		$value = $wrapBase64->{'ENCODE'}->($ptrHash->{'emailtext'});
			$item = XmlNode->new( 'autoresponder' );
			$item->addChild(XmlNode->new( 'text', 'content' => $value ) );

			$name = (split( /\@/, $ptrHash->{'absenderemail'}))[0];
			$item->setAttribute( 'name', $name );

#
# bug #33493
#
#	$item->{'ATTRIBUTE'}->('replyto',$ptrHash->{'absenderemail'});
#
#
		$value = $ptrHash->{'emailbetreff'};
			$value = $wrapBase64->{'ENCODE'}->( $value );
		chomp $value;
			$item->setAttribute( 'subject', $value );

			$autorespondersNode->addChild( $item );
      }

		$root->addChild( $autorespondersNode );

    }

    $wrapDbh->{'FINISH'}->();

}

sub makeMailboxNode {
  my ($account, $domain)=@_;

  my ($type, $is_inbox, $archive);

  my $item = XmlNode->new('mailbox');
  my $archiveName = "$dumpDir/$account\@$domain";

  if ($maildrop eq "HOMEDIR/Mailbox") {
    $is_inbox = 1;
    $type = 'mbox';

    $archive = dumpFile($archiveName, "$pop_homeDir/$account");
  } elsif ($maildrop eq "HOMEDIR/Maildir/") {
    $is_inbox = 0;
    $type='mdir';

    $archive = makeDumpFile($archiveName, "$pop_homeDir/$account/$mailBoxName");
  } else {
    $is_inbox = 0;
    $type='mbox';

    if (opendir(SPOOL,$mailSpool)) {
      my @names = grep {/^\Q$account\E$/} readdir(SPOOL);
      closedir(SPOOL);
      $archive = makeDumpFile($archiveName, "$mailSpool", \@names);
    }
  }

  $item->setAttribute('type', $type);
  if ($archive) {
    $item->setAttribute($is_inbox ? 'cid_inbox': 'cid', $archive);
  }

  return $item;
}


sub addPinfo {
  my ($root, $ptrValue, $ptrMap) = @_;
  my ($item, $plesk, $confixx, $value);

  while (($plesk,$confixx) = each %{$ptrMap}) {

		if ( $value = $ptrValue->{$confixx} )  {

			if ( $plesk eq 'locale' ) { ## map name of locale
				if ( exists $mapLocales{$value} ) {
					$value = $mapLocales{$value};
					next unless $value;
				}
			}

			if ($plesk eq 'country') {
				if (exists $mapCountries{lc($value)}) {
					$value = $mapCountries{lc($value)};
					next unless $value;
				}
			}

			$root->addChild(XmlNode->new('pinfo', 'content' => $value, 'attributes' => {'name' => $plesk}));
		}
  }
}


sub addLimits {
  my ($root, $ptrValue, $ptrMap ) = @_;
  my ($item, $plesk, $confixx, $value);
  while( ( $plesk, $confixx ) = each %{$ptrMap} ){

		if( ( $value = $ptrValue->{$confixx} ) > 0 ){
			if( $plesk eq 'disk_space' || $plesk eq 'max_traffic' ){
				$value *= 1024; ## convert to Mb
			}

			$root->addChild( XmlNode->new('limit', 'content' => $value, 'attributes' => {'name' => $plesk}) );
		}
  }
}

sub addPermissions {
  my ($root,$ptrValue,$ptrMap) = @_;
  my ($plesk,$confixx,$value);
  while(($plesk,$confixx) = each %{$ptrMap}){

		if ( $confixx=~/^\d+$/ ) {
			$value = $confixx;
		}else {
			$value = $ptrValue->{$confixx};
		}

		addPermissionNode($root, $plesk, ($value ? 'true' : 'false'));
  }
}

###############################
#
#	Reads IP information
#
###############################
sub readIpInfo()
{
	my ($ptrRow,$id,$ip,$sql);
	my (%sharedIps,%exlusiveIps);

	# standard ip is shared
	$sql = "SELECT standardip FROM admin";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		($ip) = @{$wrapDbh->{'FETCHROW'}->()};

		$exclIp{$ip} = 0;
	}
	$wrapDbh->{'FINISH'}->();

	$wrapDbh->{'EXECUTE'}->("select ip,anbieter,kunde from ipadressen");
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
		$ip = $ptrRow->[0];

		# is ip exclusive or share ?
		$exclIp{$ip} = ($ptrRow->[1] || $ptrRow->[2]);
	}
	$wrapDbh->{'FINISH'}->();
}

sub makeIpNode( $ )
{
	my $ip = shift;

	my $type = 'shared';
	if ($exclIp{$ip}) {
		$type = 'exclusive';
	}

	my $ip_node = XmlNode->new('ip');
	$ip_node->addChild(XmlNode->new('ip-type', 'content' => $type));
	$ip_node->addChild(XmlNode->new('ip-address', 'content' => $ip));
	return $ip_node;
}

sub getConfixxVersion {
  my $util = "$installDir/confixx_updatescript.pl";
  my ($out, $majorVersion, $minorVersion, $pathLevel);

  unless (-x $util) {
		return;
  }

  $out = `$util VERSION`;
  chomp $out;
  if ($out =~ /^(?:premium\s+)?(\d+)\.(\d+)\.?(\d+)?/i) {
		$majorVersion = $1;
		$minorVersion = $2;
		$patchLevel = $3 || 0;
  } else {
		$out = `$util --version`;
		chomp $out;
		if ($out =~ /^(\d+)\.(\d+)\.?(\d+)?/) {
			$majorVersion = $1;
			$minorVersion = $2;
			$patchLevel = $3 || 0;
		}
  }

  if ( $majorVersion ) {
		if (	wantarray()	) {
		  return(	$majorVersion, $minorVersion, $patchLevel	);
		} else {
	  	return 'Confixx ' . $majorVersion;
		}
  }
}

sub printAgentStatus {
  my $root = XmlNode->new('agent-status');

  my $out = getConfixxVersion();
  unless ($out && defined AgentConfig::iconvBin()) {
    my $item;
	if (defined AgentConfig::iconvBin()) {
	  $item = XmlNode->new('wrong-platform', 'content' =>'');
	} else {
	  $item = XmlNode->new('wrong-platform', 'content' => 'no iconv found on the source host');
	}

	$root->addChild($item);
  }

  $root->serialize(\*STDOUT);
}

sub loadMainConfig {
  my $pathToConf = shift||'';

  unless(-T $pathToConf){
		if ( exists( $ENV{'CONFIXX_ROOT'} ) && -d $ENV{'CONFIXX_ROOT'} ) {
			$pathToConf = $ENV{'CONFIXX_ROOT'}.'/confixx_main.conf';
		}
	}

  unless(-T $pathToConf){
    foreach my $prefix ('./','/root/confixx/','/usr/local/confixx/','/confixx/'){
      $pathToConf = $prefix.'confixx_main.conf';
      last if -T $pathToConf;
    }
  }

#
# get path to confixx from ctontab
#
  unless(-T $pathToConf){
    my(@out,$line,$run);

	my $grep = AgentConfig::grepBin();
		@out = `$grep -hr -e confixx /etc/crontab /etc/cron.d`;

		foreach $line ( @out ){
			chomp $line;
			$run = (split(' ',$line))[6];
			$run=~s/\/[^\/]*$//;
      $pathToConf = $run.'/confixx_main.conf';
			last if -T $pathToConf;
		}
  }

  unless(-T $pathToConf){
		my (@out,$line,$run);

		my $crontab = AgentConfig::crontabBin();
		@out = `$crontab -l`;

		foreach $line ( @out ) {
			chomp $line;
			next if ( $line =~ /^#/ ); ## comment
			$run = (split(' ',$line))[6];
			$run=~s/\/[^\/]*$//;
			$pathToConf = $run.'/confixx_main.conf';
			last if -T $pathToConf;
		}
	}

#
# end get path to confixx from crontab
#
  unless(-T $pathToConf){
    my (@out,$line,$dir);

		foreach $dir ('/root','/usr/local') {
		  my $find = AgentConfig::findBin();

    	@out=`$find $dir -type f -name confixx_main.conf`;

	    foreach $line ( @out ) {
		  chop $line;
    	  if ( -T $line ) {
					$pathToConf=$line;
					last;
				}
			}
			if ( -T $pathToConf ) {
				last;
			}
    }
  }

  if(-T $pathToConf){
    do $pathToConf;
  }else{
    $pathToConf='';
  }

  return $pathToConf;
}

sub getAccessHosts {
  my ($db) = @_;
  my ($sql,@hosts,$ptrRow);

  $db =~s/_/\\_/g;

  $sql = "SELECT host FROM db WHERE db = '$db'";

  if($wrapUserMysql->{'EXECUTE'}->($sql)){
  	while ($ptrRow = $wrapUserMysql->{'FETCHROW'}->()){
		push @hosts,$ptrRow->[0];
	}
  }

  $wrapUserMysql->{'FINISH'}->();

  my $ptrHosts = \@hosts;
  return $ptrHosts;
}

sub getKindsRef {
  my ($node, $name) = @_;

  my (@children, $ret);

  foreach my $key (keys %{$node}) {
    if ($key eq 'children') {
      @children = @{$node->{$key}};
    }
  }

  if ($name) {
    foreach my $child (@children) {
      if ($child->{name} eq $name) {
        push @{$ret}, $child;
      }
    }
  }else{
    $ret = \@children;
  }

  return $ret;
}

sub getKind {
  my ($node, $name) = @_;

  my (@children, $ret);
  foreach my $key (keys %{$node}) {
    if ($key eq 'children') {
      @children = @{$node->{$key}};
    }
  }

  foreach my $child (@children) {
    if ($child->{name} eq $name) {
      $ret = $child;
      last;
    }
  }
  return $ret;
}

sub printHelp {

  print <<"HELP";

Usage:
  $0 <options>

Options:
  -c |--config=<path>        path to confixx_main.conf

  -s |--get-status           get status of the agent
  -dc|--dump-accounts=<list> a coma separated list of resellers to dump
  -dd|--dump-domains=<list>  a coma separated list of customers to dump
  -da|--dump-all             make a full dump

  -lc|--get-content-list     get list of content files
  -nc|--no-content           do not make content files
  -nz|--no-compress          do not compress content files

  -h |--help                 this help

HELP
}

